      SUBROUTINE DRFFTF(N,R,WSAVE)  
C***BEGIN PROLOGUE  DRFFTF
C***DATE WRITTEN   790601   (YYMMDD)    
C***REVISION DATE  890413   (YYMMDD)    
C***CATEGORY NO.  J1A1   
C***KEYWORDS  FOURIER TRANSFORM    
C***AUTHOR  SWARZTRAUBER, P. N., (NCAR) 
C***PURPOSE  Forward transform of a dp, periodic sequence.
C***DESCRIPTION
C     From the book "Numerical Methods and Software"
C          by  D. Kahaner, C. Moler, S. Nash
C               Prentice Hall 1988
C    
C  Subroutine DRFFTF computes the Fourier coefficients of a dp  
C  perodic sequence (Fourier analysis).  The transform is defined
C  below at output parameter R.    
C    
C  Input Parameters 
C    
C  N       the length of the array R to be transformed.  The method   
C          is most efficient when N is a product of small primes.
C          N may change so long as different work arrays are provided 
C    
C  R       a dp array of length N which contains the sequence  
C          to be transformed  
C    
C  WSAVE   a dp work array which must be dimensioned at least 2*N+15
C          in the program that calls DRFFTF.  The WSAVE array must be  
C          initialized by calling subroutine DRFFTI(N,WSAVE), and a    
C          different WSAVE array must be used for each different 
C          value of N.  This initialization does not have to be  
C          repeated so long as N remains unchanged.  Thus subsequent  
C          transforms can be obtained faster than the first.
C          the same WSAVE array can be used by DRFFTF and DRFFTB.  
C    
C    
C  Output Parameters
C    
C  R       R(1) = the sum from I=1 to I=N of R(I) 
C    
C          If N is even set L = N/2; if N is odd set L = (N+1)/2 
C    
C            then for K = 2,...,L  
C    
C               R(2*K-2) = the sum from I = 1 to I = N of   
C    
C                    R(I)*COS((K-1)*(I-1)*2*PI/N) 
C    
C               R(2*K-1) = the sum from I = 1 to I = N of   
C    
C                   -R(I)*SIN((K-1)*(I-1)*2*PI/N) 
C    
C          If N is even  
C    
C               R(N) = the sum from I = 1 to I = N of  
C    
C                    (-1)**(I-1)*R(I)   
C    
C   *****  Note:    
C               This transform is unnormalized since a call of DRFFTF  
C               followed by a call of DRFFTB will multiply the input   
C               sequence by N.
C    
C  WSAVE   contains results which must not be destroyed between  
C          calls of DRFFTF or DRFFTB.
C    
C  *                                                                   *   
C  *   1. P.N. Swarztrauber, Vectorizing the FFTs, in Parallel         *   
C  *      Computations (G. Rodrigue, ed.), Academic Press, 1982,       *   
C  *      pp. 51-83.                                                   *   
C  *   2. B.L. Buzbee, The SLATEC Common Math Library, in Sources      *   
C  *      and Development of Mathematical Software (W. Cowell, ed.),   *   
C  *      Prentice-Hall, 1984, pp. 302-318.                            *   
C  *                                                                   *   
C  *********************************************************************   
C    
C***REFERENCES  (NONE)   
C***ROUTINES CALLED  DRFTF1   
C***END PROLOGUE  DRFFTF  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION       R(*)       ,WSAVE(*)   
C***FIRST EXECUTABLE STATEMENT  DRFFTF   
      IF (N .EQ. 1) RETURN    
      CALL DRFTF1 (N,R,WSAVE,WSAVE(N+1),WSAVE(2*N+1))  
      RETURN   
      END 
